QIPortalAPI.autocomplete = {};

(function()
{
    const ac = QIPortalAPI.autocomplete;

    let timeout = null;
    let loadingDone = false;

    //Call Autocomplete 350ms after end of typing
    ac.setTimer = function (e)
    {
        clearTimeout(timeout);
        timeout = setTimeout(ac.showAutocomplete, 350);
    }

    function isInArray(el, array)
    {
        let found = false;

        $.each(array,
            function ()
            {
                if ($(this).is(el))
                {
                    found = true;
                }
            });

        return found;
    }

    function searchBoxOnEnter()
    {
        //Click on enter
        $("input[id$='edt_keywords']").on('keydown',
            function (e)
            {
                if (e.which === 13 || e.keyIdentifier === 'U+000A' || e.keyIdentifier === 'Enter' || e.keyCode === 13)
                {
                    if ($('.AutocompleteFrame a.selected').length > 0)
                    {
                        e.preventDefault();
                        $('.AutocompleteFrame a.selected')[0].click();
                        return false;
                    }
                }
            });
    }

    $.fn.findNext = function (selector)
    {
        return $(selector).eq(set.index(this) + 1);
    }

    $.fn.findPrevious = function (selector)
    {
        return $(selector).eq(set.index(this) - 1);
    }

    function autocompleteEnabled()
    {
        return (QIPortalAPI.autocomplete &&
            QIPortalAPI.autocomplete.itemsCount &&
            QIPortalAPI.autocomplete.itemsCount > 0);
    }

    ac.showAutocomplete = function (thisElement)
    {
        let count = 0;
        let handler = null;
        
        function isLoadingDone()
        {
            if (loadingDone === true || ++count === 50)
            {
                clearInterval(handler);
            }
        }

        if (loadingDone === false)
        {
            count = 0;
            handler = setInterval(isLoadingDone, 50);
        }

        //Number of minimal characters where autocompleting starts from. Default is 3.
        const autocompleteDisplayFromCharCount = isNaN(parseInt(QIPortalAPI.autocomplete.autocompleteDisplayFromCharCount)) ? 3 : parseInt(QIPortalAPI.autocomplete.autocompleteDisplayFromCharCount);

        const advancedSearchJq = $("[class*='FullTextAttributeSelection']");
        const keywordsJq = $("input[id$='edt_keywords']");

        //Search inputs
        const isAdvancedSearch = advancedSearchJq.length > 0;
        let normalSearchBox, advancedSearchBox;

        if (isAdvancedSearch)
        {
            const numOfSearchBoxes = keywordsJq.length;

            if (numOfSearchBoxes > 1)
            {
                advancedSearchBox = advancedSearchJq.closest(".contentPanel").find("input[id$='edt_keywords']");
                const first = keywordsJq.eq(0);
                const second = keywordsJq.eq(1);

                if (second[0] == advancedSearchBox[0])
                    normalSearchBox = first;
                else
                    normalSearchBox = second;
            }
            else
            {
                advancedSearchBox = keywordsJq;
            }
        }
        else
        {
            normalSearchBox = keywordsJq;
        }

        //On pressing up/down arrows
        keywordsJq.off().keydown(function (e)
        {
            const selectedEl = $('.AutocompleteFrame a.selected').first();

            if (!(e.which == 13 || e.keyIdentifier == 'U+000A' || e.keyIdentifier == 'Enter' || e.keyCode == 13))
                selectedEl.removeClass('selected');

            switch (e.which)
            {
                case 40: //DOWN
                    e.preventDefault();
                    if (selectedEl.length > 0)
                    {
                        selectedEl.findNext('.AutocompleteFrame a:visible').addClass('selected');
                    }
                    else
                    {
                        //Jump to first row if no selected row
                        $('.AutocompleteFrame a:visible').first().addClass('selected');
                    }
                    break;
                case 38: //UP
                    e.preventDefault();
                    if (selectedEl.length > 0)
                    {
                        selectedEl.findPrevious('.AutocompleteFrame a:visible').addClass('selected');
                    }
                    break;
            }
        });

        keywordsJq.keyup(function (e)
        {
            if (e.key === "Escape")
            {
                $('.AutocompleteFrame').css('display', 'none');
            }
        });

        //Turn on again
        searchBoxOnEnter();

        let normalAutocompleteFrame, advancedAutocompleteFrame;
        if (normalSearchBox != null && normalSearchBox.length)
        {
            normalAutocompleteFrame = normalSearchBox.closest(".contentPanel").find('.AutocompleteFrame');
        }

        if (advancedSearchBox != null && advancedSearchBox.length)
        {
            advancedAutocompleteFrame = advancedSearchBox.closest(".contentPanel").find('.AutocompleteFrame');
        }

        //Pick focused search box and check minimal length of string
        const $searchBox = $(':focus');
        if ($searchBox.val().replace(/\s+/g, '').length < autocompleteDisplayFromCharCount)
        {
            return;
        }

        const normalSearch = !isAdvancedSearch;

        //Sending for example g.0, g.1, g.0 etc.
        function getSelectedAttrsString()
        {
            const tmp = [];
            if ($(".contentPanel input:checkbox").is(":checked"))
            {
                $.each($('.GoodsFullTextAttributes input:checkbox'),
                    function ()
                    {
                        tmp.push($(this).is(':checked') ? 'g.1' : 'g.0');
                    });

                $.each($('.TicketFullTextAttributes input:checkbox'),
                    function ()
                    {
                        tmp.push($(this).is(':checked') ? 't.1' : 't.0');
                    });

                $.each($('.PostFullTextAttributes input:checkbox'),
                    function ()
                    {
                        tmp.push($(this).is(':checked') ? 'p.1' : 'p.0');
                    });

                $.each($('.FunctionFullTextAttributes input:checkbox'),
                    function ()
                    {
                        tmp.push($(this).is(':checked') ? 'f.1' : 'f.0');
                    });
            }
            else
            {
                if (QIPortalAPI.filters.module == "QIShop")
                {
                    $.each($('.FullTextAttributes input:checkbox'),
                        function ()
                        {
                            tmp.push($(this).is(':checked') ? 'g.1' : 'g.0');
                        });
                }

                if (QIPortalAPI.filters.module == "QIHelpDesk")
                {
                    $.each($('.FullTextAttributes input:checkbox'),
                        function ()
                        {
                            tmp.push($(this).is(':checked') ? 't.1' : 't.0');
                        });
                }

                if (QIPortalAPI.filters.module == "QIPublish")
                {
                    $.each($('.FullTextAttributes input:checkbox'),
                        function ()
                        {
                            tmp.push($(this).is(':checked') ? 'p.1' : 'p.0');
                        });
                }
            }

            return tmp.join(',');
        }

        const ftAttrs = getSelectedAttrsString().toString();

        const outerHtml = $('.AutocompleteFrame').first().prop('outerHTML');

        $.ajax({
            type: 'GET',
            url: QIPortalAPI.appPath +
                'Modules/QIPortal/dataProviders/AutocompleteData.aspx?' +
                'keywords=' + $searchBox.val() +
                '&functionModule=' + QIPortalAPI.filters.module +
                '&normalSearch=' + normalSearch +
                '&ftAttrs=' + ftAttrs,
            contentType: 'application/json; charset=utf-8',
            success: function (result)
            {
                afterAjax(result);
            },
            error: function (e)
            {
                console.log('error during ajax');
            }
        });

        function afterAjax(data)
        {
            let defaultDiv;
            if ($searchBox[0] == normalSearchBox[0])
            {
                defaultDiv = normalAutocompleteFrame;
            }
            else
            {
                defaultDiv = advancedAutocompleteFrame;
            }

            const autocompleteFrame = defaultDiv;

            if ((data == null) || (data === ''))
            {
                autocompleteFrame.css('display', 'block');
                return;
            }

            const jq = $("input[id$='edt_keywords']");
            if (isAdvancedSearch)
            {
                const numOfSearchBoxes = jq.length;

                if (numOfSearchBoxes > 1)
                {
                    advancedSearchBox = $("[class*='FullTextAttributeSelection']").closest(".contentPanel").find("input[id$='edt_keywords']");
                    const first = jq.eq(0);
                    const second = jq.eq(1);

                    if (second[0] == advancedSearchBox[0])
                        normalSearchBox = first;
                    else
                        normalSearchBox = second;
                }
                else
                {
                    advancedSearchBox = jq;
                }
            }
            else
            {
                normalSearchBox = jq;
            }

            //Show/hide autocomplete on focus/blur
            if (normalSearchBox != null && normalSearchBox.length)
            {
                normalAutocompleteFrame = normalSearchBox.closest(".contentPanel").find('.AutocompleteFrame');
                normalSearchBox.on('click', function ()
                {
                    normalAutocompleteFrame.css('display', 'block');
                });
                normalSearchBox.on('blur',
                    function ()
                    {
                        setTimeout(function ()
                        {
                            normalAutocompleteFrame.css('display', 'none');
                        }, 300)
                    });
            }

            if (advancedSearchBox != null && advancedSearchBox.length)
            {
                advancedAutocompleteFrame = advancedSearchBox.closest(".contentPanel").find('.AutocompleteFrame');
                advancedSearchBox.on('click', function ()
                {
                    advancedAutocompleteFrame.css('display', 'block');
                });
                advancedSearchBox.on('blur',
                    function ()
                    {
                        setTimeout(function ()
                        {
                            advancedAutocompleteFrame.css('display', 'none');
                        }, 300)
                    });
            }

            autocompleteFrame.html(data);

            autocompleteFrame.css('display', 'block');

            $('.AutocompleteFrame a').hover(function ()
                {
                    $('.AutocompleteFrame a.selected').removeClass('selected');
                    $(this).addClass('selected');
                },
                function ()
                {
                    $(this).removeClass('selected');
                });

            //After click on term, redirect to regular search
            $('a[data-attr=SearchedTerm]').on('click',
                function (event)
                {
                    event.preventDefault();
                    const searchtext = $(this).find('.Term').text();
                    defaultDiv.closest(".contentPanel").find("input[name$='edt_keywords']").val(searchtext);
                    defaultDiv.closest(".contentPanel").find("input[name$='doSearch']").click();
                });
        }
    };


    function disableAutocomplete()
    {
        //If autocomplete enabled, disable default browser-autocomplete on search input
        if (autocompleteEnabled())
            $("input[id$='edt_keywords']").attr('autocomplete', 'off');
    }

    ac.Initialize = function ()
    {
        if (($("input[id$='edt_keywords']").length > 0) && ($('.AutocompleteFrame').length > 0))
        {
            searchBoxOnEnter();
            disableAutocomplete();
        }
    };
})();